;Copyright 1997 by Henter-Joyce, Inc.
;NSTerm, for the NS Elite  3270 emulator,
; Updated and added many functions with Gordie, 12/18/97, cw
; 5/6/97, th

;************************************************************************
;When the NS elite scripts change, increment the version here.
const NS_SCRIPT_VERSION = "98.01.30"  ;Year.Month.Day
;************************************************************************

Include "hjglobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants
Include "default.jsm"
Include "NSterm.jsh" ; includes code for problematic fields
include "NsTerm.jsm" ; Messages for NsTerm
globals
string lastline,
string lastRed,
string LastTSS,
int nColumnReading,
int nAutoRouteJAWS,
int NSTermInJAWSFind,
int gnLastHPos, int gnLastVPos,
int nAutoJump,
Int nCursor,
int nParagraphMode,
int nCheck


const
	COLOR_RED = "255000000",
	COLOR_GREEN = "000255000",
	SIG_V_MOVE = 15,
	SIG_H_MOVE = 20,
	UP_ARROW = 72,
	DOWN_ARROW = 80,
	RIGHT_ARROW = 77,
	LEFT_ARROW = 75,
	RC_UP = 1,
	RC_DOWN = 0

Void Function AutoStartEvent ()
	if (!GetStatusLineWindow ()) then
		Say (msgt1, OT_HELP) ; "your status line is disabled"
		Say (msgt2, OT_HELP) ; "for optimal performance in NS Elite"
		SayString ("use the view menu to enable your status bar")
	endif
EndFunction

Script  ScriptFileName()
if (IsSameScript ()) then
	Say (msgt3 + NS_SCRIPT_VERSION, OT_STRING) ; "NS Elite script version "
else
	ScriptAndAppNames("NS Elite 3270")
endif

EndScript

String Function GetNormalField ()
var
Int RowNumber, ;cursor row number
string strField

let nCursor = GetActiveCursor ()
RouteInvisibleToPc ()
InvisibleCursor ()
let RowNumber =GetCursorRow ()
PriorWord ()
if ((RowNumber == GetCursorRow ()) ; still on same line
&& (StringContains (GetField(), ":"))) then ; it has a colon
	let strField = GetChunk() ;GetField()
	SetActiveCursor (nCursor)
	return strField ;Say the prompt
else
	;SayString ("prompt not on left") ; testing 
	RouteInvisibleToPc () ;move back to start
	PriorLine () ; look at the line above
	if (StringContains (GetField (), ":")) then
		let strField =  GetChunk() ;GetField()
		SetActiveCursor (nCursor)
		return strField ; may say to much, needs work
;	else ;line above does not contain colon
;		RouteInvisibleToPc () ; return to start
;		let RowNumber = GetCursorRow () ; save the row number
;		NextWord () ; look for the next word
;		if ((RowNumber ==GetCursorRow ()) 
;		&& (StringContains (GetField (), ":"))) then
;			let strField = GetChunk() ;GetField()
;			SetActiveCursor (nCursor)
;			return strField ; say the field prompt on the right
;		endif ; word on right contains colon
	endif ; line above contains colon
endif ; prior word contains colon
PCCursor()
let strField = GetChunk()
SetActiveCursor (nCursor)
return strField ; should say entire word;Says the data in the input field
EndFunction

String Function GetTitleLine ()
var string strline,
int nCursor

let nCursor = GetActiveCursor ()
InvisibleCursor()
MoveToWindow(GetFocus())
let strline = GetLine()
SetActiveCursor(nCursor)
return strline
EndFunction

String Function GetDW0Prompt ()
var
string strTemp,
string strTitle,
int nTemp, int nTemp2,
int nSafety

let nSafety = 0
let nTemp = GetActiveCursor()
InvisibleCursor()
RouteInvisibleToPC()
let nTemp2 = GetCursorRow()
PriorLine()
while (GetCursorRow() < nTemp2 && nSafety < 50) ; we are moving up the screen
	if (GetColorName(GetColorText ()) == "white") then	
		let strTemp = GetWord()
		SetActiveCursor(nTemp)
		if (strTemp == "" ||
		 	strTemp == "ISSUE:" ||
			strTemp == "SCREEN:" ||
			strTemp == "REQUEST:" ||
			strTemp == "F/UP:" ||
			strTemp == "TICKLE:" ||
			strTemp == "RECEIVED:" ||	
			strTemp == "CATEGORY:" ||	
			strTemp == "REMARKS:") then
				return strTemp
		else
			return ""
		endif
	endif
	let nTemp2 = GetCursorRow()
	let nSafety = nSafety + 1	
	PriorLine()
endwhile
SetActiveCursor(nTemp)
EndFunction

String Function GetProblematicField (string strNormal)
var
	string strTemp,
	string strTitle,
	int nTemp, int nTemp2,
	int nSafety

let strTitle = GetTitleLine()
if (StringContains(strTitle, msgt4)) then
	if (StringContains (strNormal, msgt5)) then
		return PROMPT_1
	endif
endif
if (StringContains(strTitle, msgt6)) then
	if (StringContains (strNormal, msgt7)) then ; "AND/OR RESIDENCE SITUATION SINCE"
		let strTemp = GetLine()
		let nTemp = StringContains(strTemp, msgt8)	 ; ":"
		let strTemp = SubString (strTemp, 1, nTemp)
		let strTemp = PROMPT_2 + strTemp
		return strTemp
	endif
endif
if (StringContains(strTitle, msgt9)) then ; "RMEN"
	return GetLine()
endif
if (StringContains(strTitle, msgt10) || StringContains(strTitle, "MMDW")) then
	let strTemp = GetDW0Prompt ()
	if (strTemp != "") then
		return strTemp
	endif
endif	
if (StringContains(strTitle, msgt11)) then ; "IDEN"
	if (strNormal == "    ") then
		let nTemp = GetActiveCursor()
		InvisibleCursor()
		RouteInvisibleToPC()
		PriorWord()
		let strTemp = GetWord()
		SetActiveCursor(nTemp)
		if (strTemp == msgt12 || strTemp == msgt13) then
			return strTemp
		endif
	endif
endif	
;if (StringContains(strTitle, SOME_OTHER_SCREEN)) then
;	if (StringContains (strNormal, "WITH ANY FOOD OR SHELTER ITEM")) then
;		return PROMPT_1
;	elif (StringContains (strNormal, "SOME_OTHER_FIELD")) then
;		return PROMPT_2	
;	elif (StringContains (strNormal, "SOME_OTHER_FIELD")) then
;		return PROMPT_3
;	endif
;endif

return strNormal

EndFunction

String Function GetCurrentField ()
var
	string strField,
	string strNormal

let strNormal = GetNormalField()

if (strNormal == msgt14) then ; "(Y/N):"
	let strNormal = GetLine()
endif

let strField = GetProblematicField(strNormal)
if (strField != "") then 
	return strField 
else
	return strNormal
endif
EndFunction


Script ReadCurrentField ()
SayString (GetCurrentField ()) ;performs the function
EndScript


Int Function NSTermHotKeyHelp ()
var 
	string RealWindow,
	string strPage

let RealWindow = GetWindowName(GetRealWindow(GetFocus()))
if (RealWindow == msgt15) then ; "Edit Options"
	let strPage = GetDialogPageName ()
	if (strPage == msgt16) then ; "Select"
		Say (msgt17, OT_HELP) ; "Use line mode use alt l"
		Say (msgt18, OT_HELP) ; "Use block mode use alt b"
	elif (strPage == msgt19) then ; "Copy"
		Say (msgt20, OT_HELP) ; "Text use alt x"
		Say (msgt21, OT_HELP)
		Say (msgt22, OT_HELP)
		Say (msgt23, OT_HELP) ; "use fields to delimit column boundaries use alt f"
		Say (msgt24, OT_HELP) ; "use words to delimit column boundaries use alt w"
		Say (msgt25, OT_HELP) ; "Replace data on the clip board use alt r"
		Say (msgt26, OT_HELP) ; "append to existing data on the clip board use alt a"
		Say (msgt27, OT_HELP)
	elif (strPage == msgt28) then ; "Paste"
		Say (msgt29, OT_HELP) ; "Skip protected field use alt s"
		Say (msgt30, OT_HELP) ; "replace end of each field with use alt r"
		Say (msgt31, OT_HELP) ; "Expand tabs in source data use alt e"
		Say (msgt32, OT_HELP) ; "past into current fields only use alt p"
		Say (msgt33, OT_HELP) ; "do not skip protected fields use alt d"
		Say (msgt34, OT_HELP) ; "maximum paste column use alt c"
		Say (msgt35, OT_HELP) ; "maximum paste row use alt w"
		Say (msgt36, OT_HELP) ; "no word wrap use alt n"
		Say (msgt37, OT_HELP) ; "advanced use alt a"
	endif
	return TRUE
endif

return FALSE
EndFunction


Void Function HotKeyHelpDefaultLoop ()
var
	handle WinHandle,
	String RealClassName,
	String HelpPhrase,
	handle Hndl,
	int FoundHotKey,
	int SDMControlHandle,
	int WinTypeCode,
	string RealWindowName,
	int IsDialog

if (NSTermHotKeyhelp()) then return endif

Let FoundHotKey = 0
Let IsDialog = DialogActive ()
Let hndl = GetRealWindow (GetFocus())
Let RealClassName = GetWindowClass (hndl)
InvisibleCursor ()
;wn286="sdm"
if (StringContains (RealClassName, wn286)) then ; THIS IS AN SDM WINDOW
	Let IsDialog = ACTIVE
	Let WinHandle = GetRealWindow(GetFocus ())
	Let SDMControlHandle = SDMGetFirstControl (WinHandle)
	While (SDMControlHandle)
		MoveToControl (WinHandle, SDMControlHandle)
		;wn287=""
		if (GetHotKey () != wn287) then
			if ((FoundHotKey == 0) && (GetVerbosity() == BEGINNER)) then
				Say (msg288, OT_HELP) ;"Hot keys are as follows"
			EndIf
			;wn289=" use alt  "
			Let HelpPhrase = GetChunk () + wn289 + GetHotKey ()
			Say (HelpPhrase, OT_HELP)
			let FoundHotKey = 1
		EndIf
		if (IsMultiPageDialog ()) then
			let WinHandle = GetCurrentWindow()
		EndIf
		let SDMControlHandle = SDMGetNextControl (WinHandle, SDMControlHandle)
	EndWhile
else ; Not SDM Window
	Let WinHandle = GetRealWindow (GetFocus ())
	let RealWindowName = GetWindowName (WinHandle)
	if ((RealWindowName == msgt38)  ; "Display Properties"
		|| (RealWindowName == msgt15)) then ; "edit options"
		Let WinHandle=GetFirstChild (WinHandle)
	EndIf
	Let WinHandle=GetFirstChild (WinHandle)
	While (WinHandle)
		let WinTypeCode = GetWindowTypeCode (WinHandle)
		If ((WinTypeCode == WT_BUTTON) ||
			(WinTypeCode == WT_STATIC) ||
			(WinTypeCode == WT_RADIOBUTTON) ||
			(WinTypeCode == WT_CHECKBOX) ||
			(WinTypeCode == WT_GROUPBOX) || 
			(WinTypeCode == WT_3STATE) ||
			(WinTypeCode == WT_TABCONTROL)) then 
			MoveToWindow (WinHandle)
			If hndl != GetRealWindow (GetCurrentWindow ()) then
				PCCursor ()
				return
			EndIf
			;wn287=""
			if (GetHotKey() != wn287) then
				if ((FoundHotKey == 0) && (GetVerbosity() == BEGINNER)) then
					Say (msg288, OT_HELP) ;"Hot keys are as follows"
				EndIf
				;wn289=" use alt  "
				Let HelpPhrase = GetChunk () + wn289 + GetHotKey()
				Say (HelpPhrase, OT_HELP)
				let FoundHotKey = 1
			EndIf
		EndIf ; condition for static text or button
		Let WinHandle = GetNextWindow (WinHandle)
	EndWhile
EndIf
PcCursor ()
If (FoundHotKey == 0) then
	If (IsDialog) then ;only say this string if in a dialog
		;"unable to determine hot keys in this dialog"
		Say (msg450, OT_HELP) ; "can not determine hot keys in this dialog"
	EndIf
	GeneralJAWSHotKeys ()
EndIf
EndFunction

Function SayHighlightedText (handle hwnd, string buffer)
var
int nCursor

	if (GetControlID(hwnd) == 1004 && GetFocus() == hwnd) then
		if (StringContains(GetWindowName(GetRealWindow(GetFocus())), "Keyboard Viewer")) then
			let nCursor = GetActiveCursor()
			InvisibleCursor()
			MoveToControl (GetParent(GetFocus()), 1008)
			Say (buffer + msgt39, OT_BUFFER)
			SayWindow(GetCurrentWindow(), READ_EVERYTHING)
			SetActiveCursor(nCursor)
			return
		endif
	endif

	if (!InJAWSFind) then SayHighlightedText(hwnd, buffer) endif
EndFunction

Void Function EnableAutoJump (int nEnable)
let nAutoJump = nEnable
EndFunction

Void Function KeyPressedEvent (int nKey, string strKeyName, int nIsBrailleKey, int nIsScript)
	if (nKey == UP_ARROW || 
	    nKey == DOWN_ARROW || 
	    nKey == RIGHT_ARROW || 
	    nKey == LEFT_ARROW) then
		EnableAutoJump(FALSE)
	endif
EndFunction

Script test ()
MessageBox(GetLine())
EndScript

Int Function LookForAutoJump ()
var
int nVPos,
int nHPos,
int nHTemp,
int nVTemp,
int nReturn

let nVPos = GetCursorRow ()
let nHPos = GetCursorCol ()

let nReturn = FALSE

;The values can be positive or negative, so provide for both cases
let nHTemp = nHPos - gnLastHPos
if (nHTemp < 0) then
	let nHTemp = nHTemp - (2*nHTemp)
endif

let nVTemp = nVPos - gnLastVPos
if (nVTemp < 0) then
	let nVTemp = nVTemp - (2*nVTemp)
endif

;Check to see if there has been significant Vertical movement
if (nVTemp > SIG_V_MOVE) then
	let nReturn = TRUE
;Check to see if there has been significant Horizontal movement
elif (nHTemp > SIG_H_MOVE) then
	let nReturn = TRUE
endif

;Reset global variables for next time
let gnLastHPos = nHPos
let gnLastVPos = nVPos
return nReturn
EndFunction

Void Function SayNSNonHighlightedText (handle hwnd, string buffer, int nAttributes, int nTextColor, int nBackgroundColor)
	if (DialogActive () || GlobalMenuMode != MENU_INACTIVE) then 
		SayNonHighlightedText(hwnd, buffer)
		return 
	endif
	
	if (IsStatusLineWindow(hwnd)) then
		if (buffer == msgt40) then ; "INS"
			Say (msgt41, OT_STATUS) ; "Insert key mode is on"
			Say (msgt42, OT_HELP) ; "press reset key to continue"
		endif
		if (nAutoJump) then
			if(LookForAutoJump()) then
				if (ScreenChanged()) then
					let nColumnReading = FALSE
					if (!InJAWSFind) then
						Say (lastline, OT_STRING)
						if (IsTSS(buffer)) then
							let LastTSS = lastline
						endif
						let LastRed = ""
						PerformScript ReadCurrentField()
					endif
				else
					Say (GetCurrentField(), OT_FIELD)
					Say (GetChunk(), OT_CHUNK)
				endif
			endif
		else
			EnableAutoJump(TRUE)
		endif
		return
	endif
	if (InJAWSFind) then return endif
	if (GetWindowClass(hwnd) == "#32771") then
		Say (buffer, OT_BUFFER)
		return
	endif

	;Take care of bug where the letter p under cursor is continuously repeated if it is green
	if (IsJustOneChar(buffer) && buffer == "p") then
		return
	endif

	If (IsKeyPhrase(buffer)) then
		Say (buffer, OT_BUFFER)
		return
	endif

	if (ColorToRGBString (nTextColor)==COLOR_RED 
		&& !StringContains(buffer, msgt43)) then   ; "SSSS"
			if (!IsJustOneChar(buffer)) then
			Say (buffer, OT_BUFFER) 
			let LastRed = buffer
			;PerformScript ReadCurrentField()
		endif
	endif
EndFunction

Int Function ScreenChanged ()
var string strline,
int slash,
int nCursor

let nCursor = GetActiveCursor ()
InvisibleCursor()
MoveToWindow(GetFocus())
let strline = GetLine()

if (strline == "") then
	NextLine()
	let strline = GetLine()
endif

SetActiveCursor (nCursor)
if (strline == lastline) then
	return FALSE
else
	let lastline = strline
	return TRUE
endif
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes, 
int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
if (ProcessSelectText(nAttributes,buffer)) then
	return
endif
if (sFrameName == "") then
	; this text is not associated with a frame
	if (nAttributes& ATTRIB_HIGHLIGHT) then
		SayHighlightedText(hwnd,buffer)
	else
		SayNSNonHighlightedText(hwnd,buffer, nAttributes, nTextColor, nBackgroundColor)
	endif
else
	; this text is associated with a frame
	if (nEcho == ECHO_NONE) then
		return; frame is being silenced
	endif
	if (nEcho  == ECHO_ALL ||
	   (nAttributes & ATTRIB_HIGHLIGHT)) then
		; if FrameEcho is set to all or the text being written is highlighted
		Say (buffer, OT_BUFFER)
	endif
endif
EndFunction

Script SayLastRed ()
if (LastRed == "") then
	Say (msgt44, OT_STATUS)
else
	Say (LastRed, OT_STRING)
endif
EndScript

Script SayWindowTitle ()
Say (msgt45, OT_MESSAGE) ; "title = "
if (DialogActive ()) then
	PerformScript SayWindowTitle()
else
	Say (GetWindowName (GetAppMainWindow (GetFocus ())), OT_APP_NAME)
	ScreenChanged()
	Say (lastline, OT_STRING)
	PerformScript ReadCurrentField()
endif
EndScript

Script SayScreenTitle ()
Say (lastline, OT_STRING)
EndScript


Int Function IsKeyPhrase (string buffer)
if (buffer == "PRESS ENTER TO CONTINUE") then
	return TRUE
elif (buffer == "PLEASE HIT ENTER TO CONTINUE") then
	return TRUE
elif (buffer == "COMMAND SUCCESSFUL") then
	return TRUE
;elif (buffer == "other key phrase") then
;	return TRUE
endif
return FALSE
EndFunction

Int Function IsTSS (string buffer)
var int safety
SaveCursor()
InvisibleCursor()
if (SubString(buffer, 1, 3)=="TSS") then
	return TRUE
else
	let safety = 0
	MoveToWindow(GetFocus())
	while (Safety < 5)
		NextLine()
		If (GetLine() != "") then
			return FALSE
		endif	
		let safety = safety + 1
	endwhile
endif
return TRUE
EndFunction

Script SayTSS ()
Say (LastTSS, OT_STRING)
EndScript

Int Function IsJustOneChar (string phrase)
var
	 string temp
let temp = SubString (phrase, 1, 1)
;messagebox(temp + " " + phrase)

if StringContains (temp, phrase) then
	return true
else
	return false
EndIf
EndFunction

Int Function IsStatusLineWindow (handle hwnd)
return (GetWindowClass(hwnd) == "msctls_statusbar32")
EndFunction

HANDLE Function GetStatusLineWindow ()
var
handle hWnd

let hWnd = GetAppMainWindow(GetFocus())
let hWnd = GetFirstChild(hWnd)	
while (hWnd && GetWindowClass (hWnd) != "msctls_statusbar32")
let hWnd = GetNextWindow(hWnd)
endwhile 

if (IsStatusLineWindow(hWnd) && IsWindowVisible(hWnd)) then
	return hWnd
else
	return 0
endif
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
if (InJAWSFind && !(GetWindowName(GetRealWindow(FocusWindow))=="JAWS Find")) then
	let NSTermInJAWSFind = TRUE
	return
endif
if (NSTermInJAWSFind == TRUE) then
	let NSTermInJAWSFind = FALSE
	return
endif
FocusChangedEvent (FocusWindow, PrevWindow)
EndFunction

Script ColumnModeToggle ()
let nColumnReading = !nColumnReading 
if (nColumnReading) then
	Say (msgt46, OT_STATUS) ; "Column Reading On"
	JAWSCursor()
else
	Say (msgt47, OT_STATUS) ; "Column reading Off"
	PCCursor()
endif
EndScript

Script SayPriorLine ()
if (nColumnReading && IsJAWSCursor()) then
	SayColumnLine(RC_UP)
else
	PerformScript SayPriorLine()
endif
EndScript

Script SayNextLine ()
if (nColumnReading && IsJAWSCursor()) then
	SayColumnLine(RC_DOWN)
else
	PerformScript SayNextLine()
endif
EndScript

Void Function SayColumnLine (int nUp)
; Define the rule for different pages
var
string buffer,
int nColon

if (StringContains(LastLine, "APPT")) then
	if (nUp) then
		PriorLine()
	else
		NextLine()
	endif
	if (GetWord() != "--" ) then ; && GetWord() != " ") then
		SayWord()
		let buffer = GetLine()
		let nColon = StringContains(buffer, ":")
		if (nColon) then
			let nColon = nColon + 2
			let buffer = SubString (buffer, 1, nColon)
		endif
		Say (buffer, OT_BUFFER)
	endif
else
	if (nUp) then
		PerformScript SayPriorLine()
	else
		PerformScript SayNextLine()
	endif
endif
EndFunction

Script JAWSCursor ()
PerformScript JAWSCursor()
if (nAutoRouteJAWS) then RouteJAWSToPC() EndIf
EndScript

Script AutoRouteToggle ()
let nAutoRouteJAWS = !nAutoRouteJAWS
if (nAutoRouteJAWS) then
	Say (msgt48, OT_STATUS) ; "Auto Routing on"
else
	Say (msgt49, OT_STATUS)
endif
EndScript

Function SayWord ()
if (InJAWSFind && !StringContains(GetTitleLine(), "APPT")) then
	SayFromCursor ()
else
	SayWord()
EndIf
EndFunction

Script ReadChoices()
;800#
If (FREQ()) then return
elif (APPTS()) then return

;MFQ
elif (MFQM()) then return
elif (PIAE()) then return
elif (DEQY()) then return
elif (SSQM()) then return
elif (PHUS()) then return
elif (DEQM()) then return
elif (MISM()) then return
elif (CNQY()) then return
elif (RQSL()) then return
elif (PBRQ ()) then return
elif (HIQR()) then return
elif (MDBS()) then return
elif (MMQS()) then return
elif (ACLM()) then return 
elif (MAIN()) then return
elif (PEMU()) then return
elif (PESL()) then return
elif (PETS()) then return
elif (PENC()) then return
elif (PEPR()) then return
elif (PEDT()) then return
elif (PEDD()) then return
elif (PEAN()) then return
elif (PEAR()) then return
elif (PEHS()) then return
elif (PEST()) then return
elif (MSSI()) then return
elif (ESMU()) then return
elif (DMMU()) then return
endif
EndScript

int function FREQ()
var string Temp
if (StringContains(LastLine, msgt50)) then; "FREQ"
	let Temp = GetCurrentField()
	if (Temp =="SELECT AGE CATEGORY:") then
		Say (msgt51, OT_MESSAGE)		 ; "0=ALL"
		Say (msgt52, OT_HELP) ; "1=Pending over 120 days"
		Say (msgt53, OT_MESSAGE) ; "2=Pending 91 to 120 days"
		Say (msgt54, OT_MESSAGE) ; "3=Pending 61 to 90 days"
		Say (msgt55, OT_MESSAGE) ; "4=Pending 46 to 60 days"
		Say (msgt56, OT_MESSAGE) ; "5=Pending 31 to 45 days"
		Say (msgt57, OT_HELP); "6=Pending 16 to 30 days"
		Say (msgt58, OT_MESSAGE) ; "7=Pending 0 to 15 days"
	return TRUE
	EndIf
endif
return FALSE
endfunction

int function APPTS() ;  800S screen
var string Temp
if (StringContains(LastLine, msgt59)) then ; "800S"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt60)) then; "MODE:"
		Say (msgt61, OT_MESSAGE); "1=Establish"
		Say (msgt62, OT_MESSAGE); "2=Update"
		Say (msgt63, OT_MESSAGE)
	elif (StringContains(temp, msgt64)) then; "SELECT THE DESIRED FUNCTION"
		Say (msgt65, OT_MESSAGE); "1=Administrative Message"
		Say (msgt66, OT_MESSAGE) ; "2=Information Referral"
		Say (msgt67, OT_MESSAGE)		 ; "3=Leads Protective Filing"
		Say (msgt68, OT_MESSAGE)		 ; "4=Appointment Calendar Menu"
		Say (msgt69, OT_MESSAGE); "5=Query"
		Say (msgt70, OT_MESSAGE); "6=Leads Development"
		Say (msgt71, OT_MESSAGE) ; "7=Field Office Listing Request"
		Say (msgt72, OT_MESSAGE); "8=Leads Deletion"
		Say (msgt73, OT_MESSAGE); "9=T S C Listing Request"
	endif
	return TRUE
endif
return FALSE
endfunction

int function MFQM()
var string Temp
if (StringContains(LastLine, msgt74)) then ; "MFQM"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt75)) then; "SELECT ONE OF THE FOLLOWING:"
		Say (msgt76, OT_MESSAGE) ; "1=Abbreviated M B R"
		Say (msgt77, OT_MESSAGE) ; "2=Full M B R"
		Say (msgt78, OT_MESSAGE) ; "3=SSACCS Claims Control"
		Say (msgt79, OT_MESSAGE) ; "4=Future use"
		Say (msgt80, OT_MESSAGE) ; "5=newmident"
		Say (msgt81, OT_MESSAGE) ; "6=Alphident"
		Say (msgt82, OT_MESSAGE) ; "7=PIA Estimate"
		Say (msgt83, OT_MESSAGE) ; "8=SEQY Summry Earnings Query"
		Say (msgt84, OT_MESSAGE) ; "9=DEQY Detailed Earnings query"
		Say (msgt85, OT_MESSAGE); "ten=S S Q M SSID S S I 2 S S I 3 S S I 4"
		Say (msgt86, OT_MESSAGE); "eleven=PHUS fuss 1 fuss 2 and fuss 3"
		Say (msgt87, OT_MESSAGE); "twelve=fuss 4 taxation inquiry"
		Say (msgt88, OT_MESSAGE); "thirteen=ten ninety nine benefit statement"
		Say (msgt89, OT_MESSAGE); "fourteen= T P Q Y third party query"
		Say (msgt90, OT_MESSAGE); "fifteen=D E Q M delayed query menu"
		Say (msgt91, OT_MESSAGE); "sixteen=MISM miscellaneous menu"
		Say (msgt92, OT_MESSAGE) ; "seventeen=Q R S L inquiry response"
		Say (msgt93, OT_MESSAGE); "eighteen=C N Q Y consolidated query"
		Say (msgt94, OT_MESSAGE); "nineteen=R P Q Y representative payee"
		Say (msgt95, OT_MESSAGE); "twenty=P C A C S case control query"
		Say (msgt96, OT_MESSAGE); "twenty one=HCFA H I S M I"
		Say (msgt97, OT_MESSAGE); "twenty two=P B R Q pebes online"
		Say (msgt98, OT_MESSAGE); "twenty three=future use"
	elif (StringContains(temp, msgt99)) then; "ROUTE RESPONSE TO"
		Say (msgt100, OT_MESSAGE); "1=screen"
		Say (msgt101, OT_MESSAGE); "2=printer main"
		Say (msgt102, OT_MESSAGE); "3=printer"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function PIAE()
var string Temp
if (StringContains(LastLine, msgt103)) then; "PIAE"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt104)) then; "CONTACT METHOD:"
		Say (msgt105, OT_MESSAGE); "1=phone"
		Say (msgt106, OT_MESSAGE); "2=visit"
		Say (msgt107, OT_MESSAGE); "3=mail"
		Say (msgt108, OT_MESSAGE); "4=system"
	elif (StringContains(temp, msgt99)) then; "ROUTE RESPONSE TO"
		Say (msgt100, OT_MESSAGE); "1=screen"
		Say (msgt101, OT_MESSAGE); "2=printer main"
		Say (msgt102, OT_MESSAGE); "3=printer"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function DEQY()
var string Temp
if (StringContains(LastLine, msgt109)) then; "DEQY"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt99)) then; "ROUTE RESPONSE TO"
		Say (msgt100, OT_MESSAGE); "1=Screen"
		Say (msgt101, OT_MESSAGE); "2=Printer Main"
		Say (msgt102, OT_MESSAGE); "3=Printer"
	elif (StringContains(temp, MSGT110)) then; "REQUESTED DETAILS"
		Say (msgt111, OT_MESSAGE); "1=Covered details"
		Say (msgt112, OT_MESSAGE); "2=self employment"
		Say (msgt113, OT_MESSAGE); "3=m q g e and health insurance"
		Say (msgt114, OT_MESSAGE); "4=all non covered details"
		Say (msgt115, OT_MESSAGE); "5=pension"
		Say (msgt116, OT_MESSAGE); "6=railroad"
		Say (msgt117, OT_MESSAGE); "7=special wage payment"
		Say (msgt118, OT_MESSAGE); "8=employer address"
		Say (msgt119, OT_MESSAGE); "9=last employer address"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function SSQM()
var string Temp
if (StringContains(LastLine, msgt120)) then; "SSQM"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt99)) then; "ROUTE RESPONSE TO"
		Say (msgt100, OT_MESSAGE); "1=Screen"
		Say (msgt101, OT_MESSAGE); "2=Printer Main"
		Say (msgt102, OT_MESSAGE); "3=Printer"
	elif (StringContains(temp, msgt121)) then; "SELECT ONE OF THE FOLLOWING"
		Say (msgt122, OT_MESSAGE); "1=SSID Complete record request"
		Say (msgt123, OT_MESSAGE); "2=S S I 2 selective request"
		Say (msgt124, OT_MESSAGE); "3=S S I 3 general s s i query"
		Say (msgt125, OT_MESSAGE); "4=s s i 4 overpayment redertimination query"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function PHUS()
var string Temp
if (StringContains(LastLine, msgt126)) then; "PHUS"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt99)) then; "ROUTE RESPONSE TO"
		Say (msgt100, OT_MESSAGE); "1=Screen"
		Say (msgt101, OT_MESSAGE); "2=Printer Main"
		Say (msgt102, OT_MESSAGE); "3=Printer"
	elif (StringContains(temp, msgt121)) then; "SELECT ONE OF THE FOLLOWING"
		Say (msgt127, OT_MESSAGE); "1=P H U 1 payment history by bic"
		Say (msgt128, OT_MESSAGE); "2=p h u 2 payment history"
		Say (msgt129, OT_MESSAGE); "3=p h u 3 payment history bic list"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function DEQM()
var string Temp
if (StringContains(LastLine, MSGT130)) then; "DEQM"
	let Temp = GetCurrentField()
	If (StringContains(temp, MSGT121)) then; "SELECT ONE OF THE FOLLOWING"
		Say (msgt131, OT_MESSAGE); "1=h i q y offline health insurance query"
		Say (msgt132, OT_MESSAGE); "2=h i r c offline health insurance replacement card"
		Say (msgt133, OT_MESSAGE); "3=o f b e offline benefit estimate"
		Say (msgt134, OT_MESSAGE); "4=o m p q offline mbr premium query"
		Say (msgt135, OT_MESSAGE); "5=o f s q offline s s r"
		Say (msgt136, OT_MESSAGE); "6=d eigh c t delayed eigh eigh c t query"
		Say (msgt137, OT_MESSAGE); "7=d f c t delayed f eigh c t query"
		Say (msgt138, OT_MESSAGE); "8=d s i d delayed sid query"
		Say (msgt139, OT_MESSAGE); "9=d s i 2 delayed s s i 2 query"
		Say (msgt140, OT_MESSAGE); "ten=d s i 3 delayed s s i 3 query"
		Say (msgt141, OT_MESSAGE); "eleven=d s i 4 delayed s s i 4 query"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function MISM()
var string Temp
if (StringContains(LastLine, msgt142)) then; "MISM"
	let Temp = GetCurrentField()
	If (StringContains(temp, msgt121)) then; "SELECT ONE OF THE FOLLOWING"
		Say (msgt143, OT_MESSAGE); "1=d r m q drams query"
		Say (msgt144, OT_MESSAGE); "2=c r c 1 corc offline case query"
		Say (msgt145, OT_MESSAGE); "3=c r c 2 corc online counts query"
		Say (msgt146, OT_MESSAGE); "4=c r c 3 corc online s s n query"
		Say (msgt147, OT_MESSAGE); "choices 5 through 8 are for future use"
		Say (msgt148, OT_MESSAGE); "9=d t m eigh add death record"
		Say (msgt149, OT_MESSAGE); "ten=d t m c correct death record"
		Say (msgt150, OT_MESSAGE); "eleven=d t m d delete death record"
		Say (msgt151, OT_MESSAGE); "twelve=r t n d routing transmit number"
		Say (msgt152, OT_MESSAGE); "thirteen=a e q y alpha access to e i f"
		Say (msgt153, OT_MESSAGE); "fourteen=e r q y employer report query"
		Say (msgt154, OT_MESSAGE); "fifteen=s e i d s s a employee identification"
	elif (StringContains(temp, msgt99)) then; "ROUTE RESPONSE TO"
		Say (msgt100, OT_MESSAGE); "1=Screen"
		Say (msgt101, OT_MESSAGE); "2=Printer Main"
		Say (msgt102, OT_MESSAGE); "3=Printer"
		return TRUE
	EndIf
endif
return FALSE
endfunction


int function CNQY()
var string Temp
if (StringContains(LastLine, msgt155)) then; "CNQY"
	let Temp = GetCurrentField()
	If (StringContains(temp, msgt156)) then; "SELECT ANY OF THE FOLLOWING"
		Say (msgt157, OT_MESSAGE); "0=eigh eigh c t abbreviated m b r"
		Say (msgt158, OT_MESSAGE); "1=s s i d complete record request"
		Say (msgt159, OT_MESSAGE); "2=numi numident"
		Say (msgt160, OT_MESSAGE); "3=s e q y summary earnings"
		Say (msgt161, OT_MESSAGE); "4=all of above"
		Say (msgt162, OT_MESSAGE); "5=p i a e p i a estimate"
		Say (msgt163, OT_MESSAGE); "6=d e q y detail earnings"
		Say (msgt164, OT_MESSAGE); "7=s s i 2 folder location"
		Say (msgt165, OT_MESSAGE); "there is no choice 8"
		Say (msgt166, OT_MESSAGE); "9=f a c t full m b r"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function RQSL()
var string Temp
if (StringContains(LastLine, msgt167)) then; "RQSL"
	let Temp = GetCurrentField()
	If (StringContains(temp, msgt168)) then; "QUERY RESPONSE(S)"
		Say (msgt169, OT_MESSAGE); "1=rep payee screening query response"
		Say (msgt170, OT_MESSAGE); "2=rep payee full query response"
		Say (msgt171, OT_MESSAGE); "3=Individual beneficiary recipient query response"
		Say (msgt172, OT_MESSAGE); "selections 1 2 and 3 will always be returned to the screen"
		Say (msgt173, OT_MESSAGE); "4=individual rep payee beneficiary recipient list"
		Say (msgt174, OT_MESSAGE); "5=organization or institution rep payee beneficiary recipient list"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function PBRQ()
var string Temp
if (StringContains(LastLine, msgt175)) then; "PBRQ"
	let Temp = GetCurrentField()
	If (StringContains(temp, msgt99)) then; "ROUTE RESPONSE TO"
		Say (msgt100, OT_MESSAGE); "1=screen"
		Say (msgt101, OT_MESSAGE); "2=printer main"
		Say (msgt102, OT_MESSAGE); "3=printer"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function HIQR()
var string Temp
if (StringContains(LastLine, msgt176)) then; "HIQR"
	let Temp = GetCurrentField()
	If (StringContains(temp, msgt121)) then; "SELECT ONE OF THE FOLLOWING"
		Say (msgt177, OT_MESSAGE); "1=m e q y medicare enrollment query"
		Say (msgt178, OT_MESSAGE); "2=m d b q medicare direct billing "
		Say (msgt179, OT_MESSAGE); "3=m d b s medicare direct billing submenu"
		Say (msgt180, OT_MESSAGE); "4=m m q s medicare miscellaneous query submenu"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function MDBS()
var string Temp
if (StringContains(LastLine, msgt181)) then; "MDBS"
	let Temp = GetCurrentField()
	If (StringContains(temp, msgt121)) then; "SELECT ONE OF THE FOLLOWING"
		Say (msgt182, OT_MESSAGE); "1=m p b q medicare premium due balance query"
		Say (msgt183, OT_MESSAGE); "2=m b h q medicare billing history query"
		Say (msgt184, OT_MESSAGE); "3=m p p q medicare premium payment query"
		Say (msgt185, OT_MESSAGE); "4=m p a q medicare premium due adjustment query"
	elif (StringContains(temp, msgt99)) then; "ROUTE RESPONSE TO"
		Say (msgt100, OT_MESSAGE); "1=Screen"
		Say (msgt101, OT_MESSAGE); "2=Printer Main"
		Say (msgt102, OT_MESSAGE); "3=Printer"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function MMQS()
var string Temp
if (StringContains(LastLine, msgt186)) then; "MMQS"
	let Temp = GetCurrentField()
	If (StringContains(temp, msgt121)) then; "SELECT ONE OF THE FOLLOWING"
		Say (msgt187, OT_MESSAGE); "1=h t p q health insurance third party query"
		Say (msgt188, OT_MESSAGE); "2=s t p q SMI third party query"
		Say (msgt189, OT_MESSAGE); "3=m x r q medicare cross reference query"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function ACLM()
var string Temp
if (StringContains(LastLine, msgt190)) then; "ACLM"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt191)) then; "APPLICATION TYPE:"
		Say (msgt192, OT_MESSAGE)		; "1=deferred"
		Say (msgt193, OT_MESSAGE); "2=full"
		Say (msgt194, OT_MESSAGE); "3=abbreviated"
	elif (StringContains(temp, msgt195)) then; "ABBREVIATED"
		Say (msgt196, OT_MESSAGE); "1=access accountable income"
		Say (msgt197, OT_MESSAGE); "2=ineligible resident of a public institution"
		Say (msgt198, OT_MESSAGE); "3=absence from U.S."
		Say (msgt199, OT_MESSAGE); "4=excess resources"
		Say (msgt200, OT_MESSAGE);
		Say (msgt201, OT_MESSAGE); "6=not age 65 blind or disabled"
		Say (msgt202, OT_MESSAGE); "7=failure to pursue claim"
		Say (msgt203, OT_MESSAGE); "8=inmate of a penal institution"
		Say (msgt204, OT_MESSAGE); "9=not a resident of the united states"
	endif
	return TRUE
endif
return FALSE
endfunction

int function MAIN()
var string Temp
if (StringContains(LastLine, msgt205)) then; "MAIN"
	let Temp = GetCurrentField()
	if (Temp == msgt206) then; "SELECT THE DESIRED FUNCTION:"
		Say (msgt207, OT_MESSAGE); "1=Title 2 initial claims"
		Say (msgt208, OT_MESSAGE); "2=Title 2 post entitlement"
		Say (MSGT209, ot_message); "3=Title 16 claims and post entitlement"
		Say (msgt210, OT_MESSAGE); "4=Shared processes"
		Say (msgt211, OT_MESSAGE); "5=Enumeration"
		Say (msgt212, OT_MESSAGE); "6=Debt Management"
		Say (msgt213, OT_MESSAGE); "7=Title 2 Interactive Comps"
		Say (msgt214, OT_MESSAGE); "8=Title 16 Interactive Comps"
		Say (msgt215, OT_MESSAGE); "9=Master File Query"
		Say (msgt216, OT_MESSAGE); "10=Macade"
		Say (msgt217, OT_MESSAGE); "11=Appointment Referral Leads"
		Say (msgt218, OT_MESSAGE); "12=Earnings Modernization"
		Say (msgt219, OT_MESSAGE); "13=Integrity Review"
		Say (msgt220, OT_MESSAGE); "14=R S D H I Data Inputs"
		Say (msgt221, OT_MESSAGE); "15=S S I Data Inputs"
		Say (msgt222, OT_MESSAGE); "16=Administrative Applications"
		Say (msgt223, OT_MESSAGE); "17=O H A Data Inputs and Queries"
		Say (msgt224, OT_MESSAGE); "18=N D D S S Master File Menu"
		Say (msgt225, OT_MESSAGE); "19=C P S Data Inputs and Queries"
		Say (msgt226, OT_MESSAGE); "20=TRID Applications"
		Say (msgt227, OT_MESSAGE); "21=Railroad Board Data Inputs"
		Say (msgt228, OT_MESSAGE); "22=Alternate Mode Facility"
		Say (msgt229, OT_MESSAGE); "23=Representative Payee"
		Say (msgt230, OT_MESSAGE); "24=Modernized Development Worksheet"
		Say (msgt231, OT_MESSAGE); "25=W M S Listings"
		Say (msgt232, OT_MESSAGE); "26=P C Action Control System"
		Say (msgt233, OT_MESSAGE); "27=Title 2 Modernized Data Inputs"
		Say (msgt234, OT_MESSAGE); "28=Drug Addiction and Alcoholism"
		Say (msgt235, OT_MESSAGE); "29=P C Notice Processing"
		Say (msgt236, OT_MESSAGE); "30=Common Tickle"
		Say (msgt237, OT_MESSAGE); "31=T N A Notice Retreival"
		Say (msgt238, OT_MESSAGE); "32=Continuing Disability Review File"
		Say (msgt239, OT_MESSAGE); "33=Prison System"
		Say (msgt240, OT_MESSAGE); "34=Network Status"
		Say (msgt241, OT_MESSAGE); "99=Return"
	return TRUE
	EndIf
endif
return FALSE
endfunction

int function PEMU()
var string Temp
if (StringContains(LastLine, msgt242)) then; "PEMU"
	let Temp = GetCurrentField()
	if (Temp ==msgt243) then; "SELECT:"
		Say (msgt244, OT_MESSAGE); "1=Establish"
		Say (msgt245, OT_MESSAGE); "2=Update"
		Say (msgt246, OT_MESSAGE); "3=Query"
		Say (msgt247, OT_MESSAGE); "4=W M S Query"
		Say (msgt248, OT_MESSAGE); "5=Tickle Listing"
		Say (msgt249, OT_MESSAGE); "6=Inline Quality Review"
		Say (msgt250, OT_MESSAGE); "7=Online Recomp Retrieval"
		Say (msgt251, OT_MESSAGE); "8=Overnight Recomp Archive Retrieval"
	return TRUE
	EndIf
endif
return FALSE
endfunction

int function PESL()
var string Temp
if (StringContains(LastLine, msgt252)) then; "PESL"
	let Temp = GetCurrentField()
	if (Temp =="") then
		Say (msgt253, OT_MESSAGE)		; "enter 1 for change of address, 2 for name correction"
		Say (msgt254, OT_MESSAGE); "3 for death 4 for direct deposit 5 for marriage 6 for divorce"
		Say (msgt255, OT_MESSAGE); "7 for annulment 8 for nonreciept 9 for work reports ten for "
		Say (msgt256, OT_MESSAGE); "health insurance eleven for disability cessation twelve for c d r suspension"
		Say (msgt257, OT_MESSAGE); "thirteen for dev rep suspension fourteen for miscellaneous suspension termination"
		Say (msgt258, OT_MESSAGE); "fifteen for p i a recomputation sixteen for telephone seventeen for pay "
		Say (msgt259, OT_MESSAGE); "cycle eighteen for voluntary tax withholding"
	return TRUE
	EndIf
endif
return FALSE
endfunction

int function PETS()
var string Temp
if (StringContains(LastLine, msgt260)) then; "PETS"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt243)) then; "SELECT:"
		Say (msgt261, OT_MESSAGE)		; "1=transaction movement"
		Say (msgt262, OT_MESSAGE); "2=update"
		Say (msgt263, OT_MESSAGE); "3=query"
		Say (msgt264, OT_MESSAGE); "4=cancel"
		Say (msgt265, OT_MESSAGE); "5=manual clearance"
	elif (StringContains(temp, msgt266)) then; "SELECT TRANSACTION"
		SayFrame ("PETSFrame")
	return TRUE
	EndIf
endif
return FALSE
endfunction

int function PENC()
var string Temp
if (StringContains(LastLine, msgt267)) then
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt268)) then
		Say (msgt269, OT_MESSAGE); "1=beneficiary name only"
		Say (msgt270, OT_MESSAGE); "2=beneficiary name and rep payee name"
		Say (msgt271, OT_MESSAGE); "3=rep payee name"
	return TRUE
	EndIf
endif
return FALSE
endfunction

int function PEPR()
var string Temp
if (StringContains(LastLine, msgt272)) then; "PEPR"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt273)) then; "TYPE OF ACTION:"
		Say (msgt274, OT_MESSAGE); "1=beneficiary initiated recomputation"
		Say (msgt275, OT_MESSAGE); "2=rate adjustment"
	return TRUE
	EndIf
endif
return FALSE
endfunction

int function PEDT()
var string Temp
if (StringContains(LastLine, msgt276)) then; "PEDT"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt277)) then; "FURTHER ACTION NEEDED:"
		Say (msgt278, OT_MESSAGE)		; "1=possible rep payee application required"
		Say (msgt279, OT_MESSAGE); "2=lump sum death payment claim "
		Say (msgt280, OT_MESSAGE); "3=survivor benefit not currently entitled"
		Say (msgt281, OT_MESSAGE); "4=survivor benefit between sixty two and sixty five and dually entitled"
		Say (msgt282, OT_MESSAGE); "5=child in care development"
	return TRUE
	EndIf
endif
return FALSE
endfunction

int function PEDD()
var string Temp
if (StringContains(LastLine, msgt283)) then; "PEDD"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt273)) then; "TYPE OF ACTION:"
		Say (msgt284, OT_MESSAGE); "1=add or change"
		Say (msgt285, OT_MESSAGE); "2=cancel"
		Say (msgt286, OT_MESSAGE); "2=cancel"
		Say (msgt287, OT_MESSAGE); "4=cancel future bank"
	elif (StringContains(temp, msgt288)) then; "ACCOUNT TYPE:"
		Say (msgt289, OT_MESSAGE)		; "1=checking"
		Say (msgt290, OT_MESSAGE); "2=savings"
		Say (msgt291, OT_MESSAGE); "3=e b t"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function PEAN()
var string Temp
if (StringContains(LastLine, msgt292)) then; "PEAN"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt293)) then; "TYPE OF ANNULMENT:"
		Say (msgt294, OT_MESSAGE); "1=void"
		Say (msgt295, OT_MESSAGE); "2=voidable marriage"
		Say (msgt296, OT_MESSAGE); "3=alimony involved"
		Say (msgt297, OT_MESSAGE); "4=ab initio"
		Say (msgt298, OT_MESSAGE); "5=prospective only"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function PEAR()
var string Temp
if (StringContains(LastLine, msgt299)) then; "PEAR"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt243)) then; "SELECT:"
		Say (msgt300, OT_MESSAGE); "1=annual report penalty"
		Say (msgt301, OT_MESSAGE); "2=work notice"
		Say (msgt302, OT_MESSAGE); "3=questionable retirement"
		Say (msgt303, OT_MESSAGE); "4=enforcement annual report"
		return TRUE
	EndIf
endif
return FALSE
endfunction


int function PEHS()
var string Temp
if (StringContains(LastLine, msgt304)) then; "PEHS"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt305)) then; "TYPE OF ACTION:"
		Say (msgt306, OT_MESSAGE); "1=enroll"
		Say (msgt307, OT_MESSAGE); "2=refuse"
		Say (msgt308, OT_MESSAGE); "3=withdraw"
		Say (msgt309, OT_MESSAGE); "4=cancel withdrawal"
		Say (msgt310, OT_MESSAGE); "5=issue new medicare card"
	elif (StringContains(temp, msgt311)) then; "TYPE OF COVERAGE:"
		Say (msgt312, OT_MESSAGE); "1=S M I"
		Say (msgt313, OT_MESSAGE); "2=premium h i"
		Say (msgt314, OT_MESSAGE); "3=premium h i and s m i"
		return TRUE
	EndIf
endif
return FALSE
endfunction


int function PEST()
var string Temp
if (StringContains(LastLine, msgt315)) then; "PEST"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt273)) then; "TYPE OF ACTION:"
		Say (msgt316, OT_MESSAGE); "1=DEVELOPMENT OF VERIFICATION OF DEATH LAF-S9"
		Say (msgt317, OT_MESSAGE); "2=BENEFITS SUSPENDED PENDING DISABILITY DETERMINATION LAF-S9"
		Say (msgt318, OT_MESSAGE); "3=MISCELLANEOUS LAF-S9 MANUAL NOTICE NECESSARY"
		Say (msgt319, OT_MESSAGE); "4=WHEREABOUTS UNKNOWN-RSI LAFS9"
		Say (msgt320, OT_MESSAGE); "5=NEW LEGISLATIVE DECISIONS LAF S9 MANUAL NOTICE NECESSARY"
		Say (msgt321, OT_MESSAGE); "6=WAIVER OF BENEFIT PAYMENTS LAF-S9"
		Say (msgt322, OT_MESSAGE); "7=FAILURE TO RETURN SSA-7161/7162 LAF-S9"
		Say (msgt323, OT_MESSAGE); "8=WITHDRAWAL OF CLAIM SUSPENSION LAF-S9"
		Say (msgt324, OT_MESSAGE); "9=DEVELOPMENT OF ADDRESS LAF-S6"
		Say (msgt325, OT_MESSAGE); "ten =REFUSED VR SERVICES LAF-S7"
		Say (msgt326, OT_MESSAGE); "eleven=NO CHILD IN CARE LAF-S4"
		Say (msgt327, OT_MESSAGE); "twelve=ERRONEOUS DEATH REPORT BY DEFENSE DEPARTMENT LAF-T9"
		Say (msgt328, OT_MESSAGE); "thirteen=WITHDRAWAL OF CLAIM TERMINATION LAF-T&"
		return TRUE
	EndIf
endif
return FALSE
endfunction

int function MSSI()
;fix, select field does not work
var string Temp
if (StringContains(LastLine, msgt329)) then; "MSSI"
	let Temp = GetCurrentField()
	if (StringContains(temp, msgt243)) then; "SELECT:"
		Say (msgt330, OT_MESSAGE); "1=establish"
		Say (msgt331, OT_MESSAGE); "2=update"
		Say (msgt332, OT_MESSAGE); "3=query"
	elif (StringContains(temp, msgt64)) then; "SELECT THE DESIRED FUNCTION"
		Say (msgt333, OT_MESSAGE); "1=Archival Retrieval"
		Say (msgt334, OT_MESSAGE); "2=Tickle List Request"
		Say (msgt335, OT_MESSAGE); "3=New Claim"
		Say (msgt336, OT_MESSAGE); "4=Claim Update or Inquiry"
		Say (msgt337, OT_MESSAGE); "5=Claim Development"
		Say (msgt338, OT_MESSAGE); "6=Claims Clearance"
		Say (msgt339, OT_MESSAGE); "7=Case Movement"
		Say (msgt340, OT_MESSAGE); "8=W M S Query Request"
		Say (msgt341, OT_MESSAGE); "9=S S N Correction"
		Say (msgt342, OT_MESSAGE); "There is no choice 10"
		Say (msgt343, OT_MESSAGE); "11=Delete Ineligibles"
		Say (msgt344, OT_MESSAGE); "12=Manual Processes"
		Say (msgt345, OT_MESSAGE); "13=Integrity Review"
		Say (msgt346, OT_MESSAGE); "14=Decision Input"
		Say (msgt347, OT_MESSAGE); "15=Automated Computations"
		Say (msgt348, OT_MESSAGE); "16=New Claim Abbreviated"
		Say (msgt349, OT_MESSAGE); "17=Post eligibility"
		Say (msgt350, OT_MESSAGE); "18=Denied Claim reopening"
	endif
	return TRUE
endif
return FALSE
endfunction

int function ESMU()
var string Temp
if (StringContains(LastLine, msgt351)) then; "ESMU"
	let Temp = GetCurrentField()
	if (Temp == msgt207) then; "SELECT THE DESIRED FUNCTION:"
		Say (msgt352, OT_MESSAGE); "1=S S N Application Interview"
		Say (msgt353, OT_MESSAGE); "2=S S N Batch Input"
		Say (msgt354, OT_MESSAGE); "3=Print Application"
		Say (msgt355, OT_MESSAGE); "4=Clear Application"
		Say (msgt356, OT_MESSAGE); "5=Update Application"
		Say (msgt357, OT_MESSAGE); "6=Delete Application"
		Say (msgt358, OT_MESSAGE); "7=Application Status"
		Say (msgt359, OT_MESSAGE); "8=Resolve Investigate"
		Say (msgt360, OT_MESSAGE); "9=Special Indicators"
		Say (msgt361, OT_MESSAGE); "10=Birth Record Review"
	return TRUE
	EndIf
endif
return FALSE
endfunction

int function DMMU()
var string Temp
if (StringContains(LastLine, msgt362)) then
	let Temp = GetCurrentField()
	if (Temp ==msgt206) then; "SELECT THE DESIRED FUNCTION:"
		Say (msgt363, OT_MESSAGE); "1=Remittance Process"
		Say (msgt364, OT_MESSAGE); "2=Debt Resolution"
		Say (msgt365, OT_MESSAGE); "3=Debt Follow Up"
		Say (msgt366, OT_MESSAGE); "4=Setup Modify Debt"
		Say (msgt367, OT_MESSAGE); "5=Billing System"
		Say (msgt368, OT_MESSAGE); "6=Remarks"
		Say (msgt369, OT_MESSAGE); "7=Billing Issues Development"
		Say (msgt370, OT_MESSAGE); "8=Pending File Summary"
		Say (msgt371, OT_MESSAGE); "9=Master file Offline Queries"
		Say (msgt372, OT_MESSAGE); "10=W M S D M Function selection"
		Say (msgt373, OT_MESSAGE); "11=W M S D M Manual Clearance"
		Say (msgt374, OT_MESSAGE); "12=Treasury Offset Program"
	return TRUE
	EndIf
endif
return FALSE
endfunction

Script MCALReadCALForCLMTypes ()
if (StringContains(LastLine, msgt375)) then; "MCAL"
	Say (msgt376, OT_MESSAGE); "Claim types for appointment one calendar are"
	SayFrame ("MCALClaimTypeAPPT1")
	Say (msgt377, OT_MESSAGE); "Claim types for appointment two calendar are"
	SayFrame ("MCALClaimTypeAPPT2")
	Say (msgt378, OT_MESSAGE); "Claim types for appointment three calendar are"
	SayFrame ("MCALClaimTypeAPPT3")
	return TRUE
endif
return FALSE
EndScript

Script ReadRemarks ()
if (StringContains(LastLine, msgt375)) then; "MCAL"
	SayFrame ("MCALRemarks")
	return TRUE
Elif (StringContains(LastLine, msgt379)) then; "INFO"
	SayFrame ("INFORemarks")
	return TRUE
Endif
return FALSE
EndScript

Script ReadAddress ()
if (StringContains(LastLine, msgt375)) then; "MCAL"
	Say (msgt380, OT_MESSAGE); "field office address is"
	SayFrame ("FOAddress")
	return TRUE
Elif (StringContains(LastLine, msgt379)) then; "INFO"
	Say (msgt380, OT_MESSAGE); "field office address is"
	SayFrame ("INFOAddressOne")
	SayFrame ("INFOAddressTwo")
	return TRUE
Endif
return FALSE
EndScript

Script ReadOfficeHours ()
if (StringContains(LastLine, msgt375)) then; "MCAL"
	Say (msgt381, OT_MESSAGE); "Office hours are"
	SayFrame ("OfficeHours")
	return TRUE
Elif (StringContains(LastLine, msgt379)) then; "INFO"
	Say (msgt381, OT_MESSAGE); "Office hours are"
	SayFrame ("INFOOfficeHours")
	return TRUE
Endif
return FALSE
EndScript

Script ReadPhoneNumbers ()
if (StringContains(LastLine, msgt379)) then; "INFO"
	Say (msgt382, OT_MESSAGE); "General Inquiry number is"
	SayFrame ("INFOPhoneOne")
	Say (msgt383, OT_MESSAGE); "FAX number is"
	SayFrame ("INFOPhoneFax")
	Say (msgt384, OT_MESSAGE); "administrative number is"
	SayFrame ("INFOPhoneAdmin")
	Say (msgt385, OT_MESSAGE); "T T Y number is"
	SayFrame ("INFOPhoneTTY")
	return TRUE
Endif
return FALSE
EndScript

Script  HotKeyHelp()
If (MCALH()) then return
elif (INFOH()) then return
elif (FREQH()) then return
elif (APPTSH()) then return

;MFQ
elif (MFQMH()) then return
elif (PIAEH()) then return
elif (DEQYH()) then return
elif (SSQMH()) then return
elif (PHUSH()) then return
elif (DEQMH()) then return
elif (MISMH()) then return
elif (CNQYH()) then return
elif (RQSLH()) then return
elif (PBRQH()) then return
elif (HIQRH()) then return
elif (MDBSH()) then return
elif (MMQSH()) then return
elif (ACLMH()) then return 
elif (MAINH()) then return
elif (PEMUH()) then return
elif (PESLH()) then return
elif (PETSH()) then return
elif (PENCH()) then return
elif (PEPRH()) then return
elif (PEDTH()) then return
elif (PEDDH()) then return
elif (PEANH()) then return
elif (PEARH()) then return
elif (PEHSH()) then return
elif (PESTH()) then return
elif (MSSIH()) then return
elif (ESMUH()) then return
elif (DMMUH()) then return
endif
EndScript

int function MCALH()
if (StringContains(LastLine, msgt375)) then; "MCAL"
	Say (msgt386, OT_HELP); "Press Control plus Shift plus C to find out what calendar is to"
	Say (msgt387, OT_HELP); "be used for which claim types"
	Say (msgt388, OT_HELP); "Press Control plus shift plus R to reed remarks"
	Say (msgt389, OT_HELP); "Press control plus Shift plus O for field office hours"
	Say (msgt390, OT_HELP); "Press control plus Shift plus eigh for office address"
	return TRUE
else
	return FALSE
endif
endfunction

int function INFOH()
If (StringContains(LastLine, msgt379)) then; "INFO"
	Say (msgt391, OT_HELP); "Press Control plus shift plus R to reed remarks"
	Say (msgt392, OT_HELP); "Press control plus Shift plus O for field office hours"
	Say (msgt393, OT_HELP); "Press control plus Shift plus eigh for office address"
	Say (msgt394, OT_HELP); "Press control plus shift plus p for office phone numbers"
	return TRUE
else
	return FALSE
Endif
endfunction

int function FREQH()
If (StringContains(LastLine, msgt50)) then; "FREQ"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function APPTSH()
If (StringContains(LastLine, msgt59)) then; "800S"
	Say (msgt397, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt398, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function MFQMH()
If (StringContains(LastLine, msgt74)) then; "MFQM"
	Say (msgt399, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt400, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PIAEH()
If (StringContains(LastLine, msgt103)) then; "PIAE"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function DEQYH()
If (StringContains(LastLine, msgt109)) then; "DEQY"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function SSQMH()
If (StringContains(LastLine, msgt120)) then; "SSQM"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PHUSH()
If (StringContains(LastLine, msgt126)) then; "PHUS"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function DEQMH()
If (StringContains(LastLine, msgt130)) then; "DEQM"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function MISMH()
If (StringContains(LastLine, msgt142)) then; "MISM"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function CNQYH()
If (StringContains(LastLine, msgt125)) then; "CNQY"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function RQSLH()
If (StringContains(LastLine, msgt167)) then; "RQSL"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PBRQH()
If (StringContains(LastLine, msgt175)) then
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function HIQRH()
If (StringContains(LastLine, msgt176)) then
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function MDBSH()
If (StringContains(LastLine, msgt181)) then; "MDBS"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function MMQSH()
If (StringContains(LastLine, msgt186)) then; "MMQS"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function ACLMH()
If (StringContains(LastLine, msgt190)) then; "ACLM"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function MAINH()
If (StringContains(LastLine, msgt205)) then; "MAIN"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PEMUH()
If (StringContains(LastLine, msgt242)) then
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PESLH()
If (StringContains(LastLine, msgt252)) then; "PESL"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PETSH()
If (StringContains(LastLine, msgt260)) then; "PETS"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PENCH()
If (StringContains(LastLine, msgt267)) then; "PENC"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PEPRH()
If (StringContains(LastLine, msgt272)) then
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PEDTH()
If (StringContains(LastLine, msgt276)) then; "PEDT"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PEDDH()
If (StringContains(LastLine, msgt283)) then; "PEDD"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PEANH()
If (StringContains(LastLine, msgt292)) then; "PEAN"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PEARH()
If (StringContains(LastLine, msgt299)) then; "PEAR"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PEHSH()
If (StringContains(LastLine, msgt304)) then; "PEHS"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function PESTH()
If (StringContains(LastLine, msgt315)) then; "PEST"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function MSSIH()
If (StringContains(LastLine, msgt329)) then
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function ESMUH()
If (StringContains(LastLine, msgt351)) then
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

int function DMMUH()
If (StringContains(LastLine, msgt362)) then; "DMMU"
	Say (msgt395, OT_HELP); "Press Control plus shift plus M for any questions that have more than one choice"
	Say (msgt396, OT_HELP); "JAWS will reed the choices to you"
	return TRUE
else
	return FALSE
Endif
endfunction

